/*
 * Decompiled with CFR 0.152.
 */
package panther.util.resource;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import panther.util.resource.ConnectionWrapper;
import panther.util.resource.ResultSetWrapper;

public class StatementWrapper
implements Statement {
    protected Statement stmt;
    protected List resultSets = new ArrayList();
    protected ConnectionWrapper conn;
    public static final String notImplemented = "This method is not implemented in the CachedResultSet";

    public StatementWrapper(Statement statement, ConnectionWrapper connectionWrapper) {
        this.stmt = statement;
        this.conn = connectionWrapper;
    }

    public void removeResultSet(ResultSet resultSet) {
        int n = 0;
        if (this.resultSets.contains(resultSet)) {
            n = this.resultSets.indexOf(resultSet);
            this.resultSets.remove(n);
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        ResultSetWrapper resultSetWrapper = new ResultSetWrapper(this.stmt.executeQuery(string), this);
        this.resultSets.add(resultSetWrapper);
        return resultSetWrapper;
    }

    public int executeUpdate(String string) throws SQLException {
        return this.stmt.executeUpdate(string);
    }

    public void close() throws SQLException {
        int n = this.resultSets.size();
        for (int i = n - 1; i >= 0; --i) {
            ((ResultSetWrapper)this.resultSets.get(i)).close();
        }
        this.stmt.close();
        this.conn.removeStatement(this);
    }

    public int getMaxFieldSize() throws SQLException {
        return this.stmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.stmt.setMaxFieldSize(n);
    }

    public int getMaxRows() throws SQLException {
        return this.stmt.getMaxRows();
    }

    public void setMaxRows(int n) throws SQLException {
        this.stmt.setMaxRows(n);
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.stmt.setEscapeProcessing(bl);
    }

    public int getQueryTimeout() throws SQLException {
        return this.stmt.getQueryTimeout();
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.stmt.setQueryTimeout(n);
    }

    public void cancel() throws SQLException {
        this.stmt.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.stmt.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.stmt.clearWarnings();
    }

    public void setCursorName(String string) throws SQLException {
        this.stmt.setCursorName(string);
    }

    public boolean execute(String string) throws SQLException {
        try {
            return this.stmt.execute(string);
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        ResultSetWrapper resultSetWrapper = new ResultSetWrapper(this.stmt.getResultSet(), this);
        if (!this.resultSets.contains(resultSetWrapper)) {
            this.resultSets.add(resultSetWrapper);
        }
        return resultSetWrapper;
    }

    public int getUpdateCount() throws SQLException {
        return this.stmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.stmt.getMoreResults();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.stmt.setFetchDirection(n);
    }

    public int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    public void setFetchSize(int n) throws SQLException {
        this.stmt.setFetchSize(n);
    }

    public int getFetchSize() throws SQLException {
        return this.stmt.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    public void addBatch(String string) throws SQLException {
        this.stmt.addBatch(string);
    }

    public void clearBatch() throws SQLException {
        this.stmt.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.stmt.executeBatch();
    }

    public Connection getConnection() throws SQLException {
        return this.stmt.getConnection();
    }

    public boolean getMoreResults(int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public int executeUpdate(String string, int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public boolean execute(String string, int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }
}

